#pragma once

#include <yandex/maps/wiki/revision/common.h>
#include "sql_strings.h"

namespace maps::wiki::revision {

const std::string BRANCH_COLUMNS =
    sql::col::ID + "," +
    sql::col::CREATED_BY + "," + sql::col::FINISHED_BY + "," +
    sql::col::TYPE + "," + sql::col::STATE + "," +
    sql::col::CREATED_AT + "," + sql::col::FINISHED_AT + "," +
    sql::func::HSTORE_TO_ARRAY + "(" + sql::col::ATTRIBUTES + ") AS " + sql::col::ATTRIBUTES;

class BranchData {
public:
    explicit BranchData(const pqxx::row& row);

    const DBID id;
    const BranchType type;
    const BranchState state;
    const UserID createdBy;
    const UserID finishedBy;

    const std::string createdAt;
    const std::string finishedAt;
    const Attributes attributes;
};

} // namespace maps::wiki::revision
