#pragma once

#include <yandex/maps/wiki/revision/common.h>
#include "branch_data.h"
#include <boost/utility.hpp>

namespace maps::wiki::revision {

class BranchManagerImpl : public boost::noncopyable {
public:
    explicit BranchManagerImpl(pqxx::transaction_base& work);

    pqxx::transaction_base& work() const { return work_; }


    BranchData create(BranchType type, UserID createdBy, const Attributes& attributes) const;

    BranchData loadByType(BranchType type, bool lock = false) const;
    BranchData loadById(DBID id, bool lock = false) const;

private:
    pqxx::transaction_base& work_;
};

} // namespace maps::wiki::revision
