#pragma once

#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>

#include <boost/utility.hpp>


namespace maps::wiki::revision {

class CommitApprover : public boost::noncopyable {

public:
    explicit CommitApprover(Transaction& work);

    // return approved commits set
    DBIDSet process(const DBIDSet& commitIds) const;
    DBIDSet processAll(DBID maxCommitId) const;

private:
    // protect for concurrent approve operations
    // return draft commits
    DBIDSet lockCommits(const DBIDSet& commitIds) const;
    DBIDSet lockAllCommits(DBID maxCommitId) const;

    void processDraftCommits(const DBIDSet& commitIds) const;

private:
    Transaction& work_;
};

} // namespace maps::wiki::revision
