#pragma once

#include <yandex/maps/wiki/revision/commit_manager.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>

namespace maps::wiki::revision {

// Detailed description and definitions:
// https://wiki.yandex-team.ru/maps/dev/core/wikimap/mapspro/revert
// https://wiki.yandex-team.ru/maps/dev/core/wikimap/mapspro/approve

const DBIDSet EXCLUDE_NO_COMMITS;

bool hasDependentCommitsInTrunk(Transaction& work, const DBIDSet& commitIds);

DBIDSet findDependentCommitsInTrunk(
    Transaction& work,
    const DBIDSet& commitIds,
    const ResultChecker& resultChecker = RESULT_CHECKER_DUMMY);

/**
 * @note Commits from `excludeCommitIds` are not considered as being
 * draft. `EXCLUDE_NO_COMMITS` constant can be used if no commits must be
 * skipped.
 */
bool hasDraftContributingCommitsWithoutOriginal(
    Transaction& work,
    const DBIDSet& commitIds,
    const DBIDSet& excludeCommitIds);

DBIDSet findDraftContributingCommits(
    Transaction& work,
    const DBIDSet& commitIds,
    const DBIDSet& excludeCommitIds,
    const ContributingCommitsOptions& options);

DBIDSet findAllDraftContributingCommits(
    Transaction& work,
    const DBIDSet& commitIds,
    const DBIDSet& excludeCommitIds);

} // namespace maps::wiki::revision
