#pragma once

#include "commit_data.h"

#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>


namespace maps::wiki::revision {

// Detailed description and definitions:
// https://wiki.yandex-team.ru/maps/dev/core/wikimap/mapspro/revert

struct RevertCommitsResult {
    CommitData createdCommitData;
    DBIDSet revertedCommitIds;
};

DBIDSet getRevertedCommitIds(Transaction& work, const DBIDSet& commitIds);

RevertCommitsResult revertCommitsInTrunk(Transaction& work, const DBIDSet& commitIds,
    UserID userId, Attributes commitAttributes);

} // namespace maps::wiki::revision
