#pragma once

#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/revision/snapshot_id.h>
#include <yandex/maps/wiki/revision/filters.h>
#include <yandex/maps/wiki/revision/objectrevision.h>
#include <yandex/maps/wiki/revision/revisionid.h>

#include <cstddef>
#include <fstream>
#include <sstream>
#include <string>
#include <map>

namespace maps::wiki::revision {

using OptionalSize = std::optional<size_t>;
using OptionalString = std::optional<std::string>;

const OptionalSize NO_LIMIT = std::nullopt;
const OptionalString EMPTY_QUERY = std::nullopt;
const OptionalDBID NO_APPROVE_ORDER = std::nullopt;
constexpr DBID NO_COMMIT_ID = 0;

using OptionalSnapshotId = std::optional<SnapshotId>;
const OptionalSnapshotId NO_SNAPSHOT_ID = std::nullopt;

using RevisionIdToRevisionMap = std::map<RevisionID, ObjectRevision>;
using ObjectIdToRevisionMap = std::map<DBID, ObjectRevision>;

enum class LoadLimitations
{
    //include all revisions from all branches
    None,
    //include all revisions from current branch
    Branch,
    //include only head revisions from current branch
    Snapshot
};

} // namespace maps::wiki::revision
