#include "config.h"
#include "context.h"
#include "filter_helpers.h"
#include "sql_strings.h"

#include <ostream>

namespace maps::wiki::revision::db {
namespace {

const Fields REVISION_SELECT_LIST{
    Field::ObjectId,
    Field::CommitId,
    Field::IsDeleted,
    Field::PrevCommitId,
    Field::NextCommitId,
    Field::AttributesId,
    Field::GeometryId,
    Field::DescriptionId,
    Field::MasterObjectId,
    Field::SlaveObjectId,
    Field::Attributes
};

const Fields REVISION_ID_SELECT_LIST{
    Field::ObjectId,
    Field::CommitId
};

} //anonymous namespace

std::ostream& operator<< (std::ostream& stream, Field dataField)
{
    switch (dataField) {
        case Field::Attributes:
            stream << sql::col::ATTRIBUTES;
            break;

        case Field::ObjectId:
            stream << sql::col::OBJECT_ID;
            break;

        case Field::CommitId:
            stream << sql::col::COMMIT_ID;
            break;

        case Field::IsDeleted:
            stream << sql::col::IS_DELETED;
            break;

        case Field::PrevCommitId:
            stream << sql::col::PREV_COMMIT_ID;
            break;

        case Field::NextCommitId:
            stream << sql::col::NEXT_COMMIT_ID;
            break;

        case Field::AttributesId:
            stream << sql::col::ATTRIBUTES_ID;
            break;

        case Field::GeometryId:
            stream << sql::col::GEOMETRY_ID;
            break;

        case Field::DescriptionId:
            stream << sql::col::DESCRIPTION_ID;
            break;

        case Field::MasterObjectId:
            stream << sql::col::MASTER_OBJECT_ID;
            break;

        case Field::SlaveObjectId:
            stream << sql::col::SLAVE_OBJECT_ID;
            break;
    };

    return stream;
}

Tables
affectedTables(
    const filters::Context& ctx
)
{
    Tables tables;
    if (ctx.usedAttrsTable()) {
        tables.insert(Table::Attributes);
    }
    return tables;
}

StructuredQuery
StructuredQueryProvider::revisionId(
    pqxx::connection_base& conn,
    const filters::FilterExpr& expr
)
{
    filters::Context ctx(conn);

    auto filters = classifyFilters(expr);

    StructuredQuery result;
    result.subqueries.reserve(filters.size());
    for (const auto& filterPair: filters) {
        //it is critical to use the same filter context here
        //to get correct with expression usage
        //resetting filterContext usedAttrsTable flag
        ctx.resetUsageFlags();
        auto statement = filterPair.second->evalQuery(ctx);
        result.subqueries.emplace_back(StructuredSubquery{
            filterPair.first,
            std::move(statement),
            affectedTables(ctx),
            REVISION_ID_SELECT_LIST
        });
    }
    result.subqueries.shrink_to_fit();
    return result;
}

StructuredQuery
StructuredQueryProvider::revision(
    pqxx::connection_base& conn,
    const filters::FilterExpr& expr
)
{
    filters::Context ctx(conn);

    auto filters = classifyFilters(expr);

    StructuredQuery result;
    result.subqueries.reserve(filters.size());
    for (const auto& filterPair: filters) {
        auto statement = filterPair.second->evalQuery(ctx);

        Tables tables;
        //attributes should always be joined
        tables.insert(Table::Attributes);

        result.subqueries.emplace_back(StructuredSubquery{
            filterPair.first,
            std::move(statement),
            std::move(tables),
            REVISION_SELECT_LIST
        });
    }
    result.subqueries.shrink_to_fit();
    return result;
}

} // namespace maps::wiki::revision::db
