#pragma once

/**
 * This module introduces data structures needed to represent
 * style of ObjectRevision and its Data representation in underlying PostgreSQL storage
 */

#include <yandex/maps/wiki/revision/filters.h>
#include "sql_strings.h"

#include <map>
#include <ostream>
#include <set>
#include <string>
#include <vector>

namespace maps::wiki::revision::db {

/**
 * This enumeration represents parts of ObjectData to be loaded from database
 */
enum class Field
{
    ObjectId,
    CommitId,

    IsDeleted,

    PrevCommitId,
    NextCommitId,

    AttributesId,
    GeometryId,
    DescriptionId,

    MasterObjectId,
    SlaveObjectId,

    Attributes,
};
std::ostream& operator<< (std::ostream& stream, Field dataField);
using Fields = std::set<Field>;


enum class Partition
{
    RegularWithGeometry,
    RegularWithoutGeometry,
    Relation
};
using Partitions = std::set<Partition>;

const Partitions ALL_PARTITIONS{
    Partition::RegularWithGeometry,
    Partition::RegularWithoutGeometry,
    Partition::Relation,
};
const Partitions MASTER_POSSESSORS{
    Partition::Relation,
};
const Partitions PARTITIONS_WITHOUT_SLAVES{
    Partition::RegularWithGeometry,
    Partition::RegularWithoutGeometry,
};

enum class Table
{
    Revision,
    Commit,
    Attributes,
    Geometry,
    Description
};
using Tables = std::set<Table>;

//TODO: suggest better naming
struct StructuredSubquery
{
    Partitions partitions;
    std::string filterStatement;
    Tables joinList;
    Fields selectList;
};

//Wraps a std::vector<Config>,
//which should be shared between filters
struct StructuredQuery
{
    std::vector<StructuredSubquery> subqueries;
};

class StructuredQueryProvider
{
public:
    static StructuredQuery revisionId(
        pqxx::connection_base& conn,
        const filters::FilterExpr& expr
    );

    static StructuredQuery revision(
        pqxx::connection_base& conn,
        const filters::FilterExpr& expr
    );
};

} // namespace maps::wiki::revision::db
