#include "context.h"
#include "sql_strings.h"

namespace maps::wiki::revision::filters {

namespace {

const std::string ATTRIBUTES_FIELD =
    sql::alias::ATTRIBUTES + "." + sql::col::CONTENTS;

} // namespace

Context::Context(pqxx::connection_base& conn)
    : conn_(conn)
    , usedAttrsTable_(false)
{}

std::string
Context::createParamValue(Treatment treatment, std::string&& value)
{
    switch (treatment)
    {
        case Treatment::String:
            return conn_.quote(value);
        case Treatment::Direct:
            return value;
    }
}

const std::string&
Context::attrsField()
{
    usedAttrsTable_ = true;
    return ATTRIBUTES_FIELD;
}

} // namespace maps::wiki::revision::filters
