#pragma once

#include <yandex/maps/wiki/revision/common.h>

#include <string>
#include <sstream>

namespace maps::wiki::revision::filters {

const size_t COORDINATE_PRECISION = 12;

enum class Treatment
{
    Direct,
    String
};

class Context
{
public:
    explicit Context(pqxx::connection_base& conn);

    template<class ValT>
    std::string addParam(Treatment treatment, const ValT& value)
    {
        std::ostringstream os;
        os.precision(COORDINATE_PRECISION);
        os << value;
        return createParamValue(treatment, os.str());
    }

    const std::string& attrsField();

    bool usedAttrsTable() const { return usedAttrsTable_; }
    void resetUsageFlags() { usedAttrsTable_ = false; }

    std::string esc(const std::string& s) { return conn_.esc(s); }
    std::string quote(const std::string& s) { return conn_.quote(s); }

private:
    std::string createParamValue(Treatment treatment, std::string&& value);

    pqxx::connection_base& conn_;
    bool usedAttrsTable_;
};

} // namespace maps::wiki::revision::filters
