#pragma once

#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/revision/branch.h>

#include <memory>
#include <list>
#include <map>

namespace maps::wiki::revision {

class BranchManagerImpl;

class BranchManager {
public:
    explicit BranchManager(pqxx::transaction_base& work);
    ~BranchManager();

    Branch createApproved(UserID createdBy, const Attributes& attributes) const;
    Branch createStable(UserID createdBy, const Attributes& attributes) const;


    static const size_t UNLIMITED;

    using BranchLimits = std::map<BranchType, size_t>;
    using Branches = std::list<Branch>;

    // result order: Trunk, Approved, Stable, others (Archive | Deleted, last - oldest)
    Branches load(const BranchLimits& branchLimits) const;

    Branches load(const DBIDSet& branchIds) const;

    Branch loadTrunk() const;
    Branch loadApproved() const;
    Branch loadStable() const;
    Branch load(DBID branchId) const;

    // throw maps::RuntimeError for invalid @branchStr param
    Branch loadByString(const std::string& branchStr) const;

private:
    std::unique_ptr<BranchManagerImpl> impl_;
};

} // namespace maps::wiki::revision
