#pragma once

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::revision {

class ConcurrentChangesException : public Exception {};
class ConcurrentLockDataException : public ConcurrentChangesException {};
class ConflictsFoundException : public ConcurrentChangesException {};
class AlreadyDeletedException : public Exception {};
class AlreadyExistsException : public Exception {};

class BranchNotExistsException : public Exception {};
class BranchUnavailableException : public Exception {};
class BranchInProgressException : public Exception {};
class BranchForbiddenOperationException : public Exception {};
class ApprovedBranchAlreadyExistsException : public Exception {};
class StableBranchAlreadyExistsException : public Exception {};
class StableBranchAlreadyFinishedException : public Exception {};
class BranchReadOnlyException : public Exception {};

class BranchLockIdOutOfRange : public Exception {};
class BranchAlreadyLockedException : public Exception {};
class InvalidBranchTypeException : public Exception {};

class AlreadyRevertedCommitsException : public Exception {};
class AlreadyRevertedDirectlyCommitsException : public Exception {};

} // namespace maps::wiki::revision
