#pragma once

#include <yandex/maps/wiki/revision/reader.h>
#include <yandex/maps/wiki/revision/snapshot.h>

namespace maps::wiki::revision {

class HistoricalSnapshotImpl;

/// Interface to read all ID's and revisions limited by minCommitId/maxCommitId
class HistoricalSnapshot {
public:
    explicit HistoricalSnapshot(std::shared_ptr<HistoricalSnapshotImpl> impl);
    ~HistoricalSnapshot();

    Reader reader() const;

    DBID minCommitId() const;
    DBID maxCommitId() const;

    /**
     * In methods below:  deleted revisions are also loaded.
     */
    RevisionIds revisionIdsByFilter(const filters::FilterExpr& expr) const;
    RevisionIds revisionIdsByFilter(const ConstRange<DBID>& objectIds,
        const filters::FilterExpr& expr) const;

    Revisions relationsByFilter(const filters::FilterExpr& expr) const;

private:
    std::shared_ptr<HistoricalSnapshotImpl> impl_;
};

} // namespace maps::wiki::revision
