#pragma once

#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/revision/revisionid.h>

#include <memory>
#include <list>

namespace maps::wiki::revision {

class RevisionData;
class ObjectRevision;
class ObjectRevisionImpl;
class ReaderImpl;

using Revisions = std::list<ObjectRevision>;

class ObjectRevision {
public:
    using ID = RevisionID;
    using Data = ObjectData;

    ObjectRevision(
        const ID& id,
        const RevisionData& revisionData,
        ObjectData data);

    ~ObjectRevision();

    bool operator< (const ObjectRevision& toCompare) const
    {
        return (id() < toCompare.id());
    }

    RevisionType type() const { return data().revisionType(); }

    const ID& id() const;

    ID prevId() const; // return empty id if it's the first revision
    ID nextTrunkId() const; // return empty id if it's the recent revision in trunk branch

    const Data& data() const &;
    Data&& data() &&;

    bool hasDescription() const;

    const RevisionData& revisionData() const; // for tests only

private:
    friend class ReaderImpl;

    void setGeometry(const Wkb& wkb);
    void setDescription(const Description& description);

private:
    std::shared_ptr<ObjectRevisionImpl> impl_;
};

} // namespace maps::wiki::revision
