#pragma once

#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/revision/objectrevision.h>
#include <yandex/maps/wiki/revision/revisionid.h>
#include <yandex/maps/wiki/revision/diff.h>
#include <yandex/maps/wiki/revision/filters.h>

#include <vector>
#include <list>
#include <memory>

namespace maps::wiki::revision {

class ReaderImpl;

/// Interface to read ID's and revisions directly
class Reader {
public:
    explicit Reader(std::shared_ptr<ReaderImpl> impl);
    ~Reader();

    pqxx::transaction_base& work() const;
    DBID branchId() const;


    /**
     * In methods below:  deleted revisions are also loaded.
     */

    ObjectRevision loadRevision(const RevisionID& revisionId) const;
    std::optional<ObjectRevision> tryLoadRevision(const RevisionID& revisionId) const;

    Revisions loadRevisions(const ConstRange<RevisionID>& ids) const;
    Revisions loadRevisions(
        const ConstRange<RevisionID>& ids, const filters::FilterExpr& expr) const;
    /**
     * WARN: these methods aren't pipelined in any way.
     * Think twice about the amount of data that will be returned
     */
    Revisions loadRevisions(const filters::FilterExpr& expr) const;
    RevisionIds loadRevisionIds(const filters::FilterExpr& expr) const;

    /**
     * Load commit contents.
     */
    RevisionIds commitRevisionIds(DBID commitId) const;
    Revisions commitRevisions(DBID commitId) const;

    //default: Skip
    void setDescriptionLoadingMode(DescriptionLoadingMode mode);


    /**
     * Diff support
     */
    CommitDiff commitDiff(DBID commitId) const;

private:
    std::shared_ptr<ReaderImpl> impl_;
};

} // namespace maps::wiki::revision
