#pragma once

#include <yandex/maps/wiki/revision/reader.h>
#include <yandex/maps/wiki/revision/snapshot_id.h>

#include <ostream>
#include <map>

namespace maps::wiki::revision {

class SnapshotImpl;

/// Interface to read last ID's and revisions limited by maxCommitId
class Snapshot {
public:
    explicit Snapshot(std::shared_ptr<SnapshotImpl> impl);
    ~Snapshot();

    Reader reader() const;

    DBID maxCommitId() const;

    /**
     * In methods below:  deleted revisions are not loaded.
     */

    RevisionIds revisionIdsByRegion(
        double x1, double y1, double x2, double y2) const;

    Revisions loadMasterRelations(DBID objectId) const;
    Revisions loadMasterRelations(const ConstRange<DBID>& objectIds) const;

    Revisions loadSlaveRelations(DBID objectId) const;
    Revisions loadSlaveRelations(const ConstRange<DBID>& objectIds) const;

    /**
     * In methods below: deleted revisions are also loaded.
     */

    /// data be absent from results for non-existent object revisions
    std::map<DBID, ObjectRevision> objectRevisions(const ConstRange<DBID>& objectIds) const;
    Revisions objectRevisionsByFilter(const filters::FilterExpr& expr) const;

    RevisionIds objectRevisionIds(const ConstRange<DBID>& objectIds) const;
    RevisionIds revisionIdsByFilter(const filters::FilterExpr& expr) const;
    RevisionIds revisionIdsByFilter(
        const ConstRange<DBID>& objectIds,
        const filters::FilterExpr& expr) const;

    std::optional<ObjectRevision> objectRevision(DBID objectId) const;

    /// Result is ids vector if cumulative ids count <= limit, std::nullopt otherwise
    std::optional<RevisionIds> tryLoadRevisionIdsByFilter(
        const filters::FilterExpr& expr, size_t limit) const;

    Revisions relationsByFilter(const filters::FilterExpr& expr) const;

    std::optional<Revisions> tryLoadRelationsByFilter(
        const filters::FilterExpr& expr, size_t limit) const;

    Revisions loadMasterRelations(
        const ConstRange<DBID>& objectIds,
        const filters::FilterExpr& expr) const;
    Revisions loadSlaveRelations(
        const ConstRange<DBID>& objectIds,
        const filters::FilterExpr& expr) const;

private:
    std::shared_ptr<SnapshotImpl> impl_;
};

} // namespace maps::wiki::revision
