#pragma once

#include <yandex/maps/wiki/revision/common.h>

#include <maps/libs/common/include/pimpl_utils.h>

#include <ostream>

namespace maps::wiki::revision {

class SnapshotId
{
public:
    DBID approveOrder() const;
    DBID commitId() const;

    bool hasApproveOrder() const;

    //returns true when SnapshotId specifies an empty snapshot
    //(this means any request will return empty result)
    bool empty() const;

    //may issue additional database request for loading Commit by commitId,
    //will throw if commit doesn't belong to branch of BranchType
    static SnapshotId fromCommit(
        DBID commitId,
        BranchType branchType,
        pqxx::transaction_base& txn
    );

    COPYABLE_PIMPL_DECLARATIONS(SnapshotId)
};
std::ostream& operator<<(std::ostream& stream, const SnapshotId& snapshotId);

} // namespace maps::wiki::revision
