#pragma once

#include <yandex/maps/wiki/revision/common.h>

#include <mutex>
#include <list>
#include <vector>

namespace maps::wiki::revision {

class ObjectIdGenerator {
public:
    ObjectIdGenerator() = default;

    void clear();

    DBID newObjectId(pqxx::transaction_base& work);

    static std::list<ObjectIdRange> newObjectIds(
        pqxx::transaction_base& work, size_t number, bool optimize);

    static DBID lastObjectId(pqxx::transaction_base& work);

    /// increase object id sequence by the number
    /// returns the last acquired object id
    static DBID reserveObjectIds(pqxx::transaction_base& work, size_t number);

private:
    DBID tryNewObjectId();

private:
    std::mutex mutex_;
    std::vector<DBID> freeIds_;
};

} // namespace maps::wiki::revision
