#include <yandex/maps/wiki/revision/objectrevision.h>

#include "revision_data.h"

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::revision {

class ObjectRevisionImpl
{
public:
    ObjectRevisionImpl(
            const RevisionID& id,
            const RevisionData& revisionData,
            ObjectData data)
        : id(id)
        , revisionData(revisionData)
        , data(std::move(data))
    {
        if (!revisionData.isRegularObject()) {
            data.relationData = RelationData(
                revisionData.masterObjectId, revisionData.slaveObjectId);
        }
    }

    const RevisionID id;
    const RevisionData revisionData;
    ObjectData data;
};

ObjectRevision::ObjectRevision(
        const ID& id,
        const RevisionData& revisionData,
        ObjectData data)
    : impl_(std::make_shared<ObjectRevisionImpl>(id, revisionData, std::move(data)))
{
    REQUIRE(!id.empty(), "empty revision id");
}

ObjectRevision::~ObjectRevision() = default;

const ObjectRevision::ID&
ObjectRevision::id() const
{
    return impl_->id;
}

ObjectRevision::ID
ObjectRevision::prevId() const
{
    DBID commitId = impl_->revisionData.prevCommitId;
    if (!commitId) {
        return ID();
    }
    return ID(impl_->id.objectId(), commitId);
}

ObjectRevision::ID
ObjectRevision::nextTrunkId() const
{
    DBID commitId = impl_->revisionData.nextCommitId;
    if (!commitId) {
        return ID();
    }
    return ID(impl_->id.objectId(), commitId);
}

const ObjectRevision::Data&
ObjectRevision::data() const &
{
    return impl_->data;
}

ObjectRevision::Data&& ObjectRevision::data() &&
{
    return std::move(impl_->data);
}

const RevisionData&
ObjectRevision::revisionData() const
{
    return impl_->revisionData;
}

bool
ObjectRevision::hasDescription() const
{
    return impl_->revisionData.descriptionId != 0;
}

void
ObjectRevision::setGeometry(const Wkb& wkb)
{
    impl_->data.geometry = wkb;
}

void
ObjectRevision::setDescription(const Description& description)
{
    impl_->data.description = description;
}

} // namespace maps::wiki::revision
