#pragma once

#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/revision/range.h>
#include <yandex/maps/wiki/revision/objectrevision.h>
#include <map>

namespace maps::wiki::revision {

using CommitIdToObjectIds = std::map<DBID, DBIDSet>;

struct QueryGenerator {

static size_t countRows(const CommitIdToObjectIds& commits); 

static std::string buildFilterByAttrValues(
    const std::string& fieldName, const DBIDSet& ids);

static std::string buildSpecialFilter(
    const CommitIdToObjectIds& commit2objects, const std::string& commitFieldName);

static std::pair<CommitIdToObjectIds, size_t> buildCommitIdToObjectIds(
    const ConstRange<ObjectRevision::ID>& ids);

};

} // namespace maps::wiki::revision
