#include <yandex/maps/wiki/revision/range_helpers.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::revision {

DBIDSet idsToSet(const ConstRange<DBID>& ids)
{
    if (ids.empty()) {
        return {};
    }

    DBIDSet result;
    auto it = ids.iterator();
    for (const auto* idp = it->next(); idp != nullptr; idp = it->next()) {
        REQUIRE(*idp != 0, "invalid id");
        REQUIRE(result.insert(*idp).second, "duplicated id " << *idp);
    }
    return result;
}

} // namespace maps::wiki::revision
