#pragma once

#include <yandex/maps/wiki/revision/objectrevision.h>
#include <yandex/maps/wiki/revision/revisionid.h>
#include "common.h"

#include <list>
#include <map>
#include <string>
#include <unordered_set>
#include <vector>

namespace maps::wiki::revision {

RevisionData loadRevisionDataFromPqxx(const pqxx::row& row);
RevisionID loadRevisionIdFromPqxx(const pqxx::row& pqxxTuple);
RevisionIds loadRevisionIdsFromPqxx(const pqxx::result& pqxxResult);
Revisions loadRevisionsFromPqxx(const pqxx::result& pqxxResult);
RevisionIdToRevisionMap toRevisionsMap(const Revisions& revisions);
ObjectIdToRevisionMap toObjectsMap(const Revisions& revisions);

/**
 * When reading from stable or archive branch,
 * there is no way of correct excluding
 * of past revisions on PostgreSQL side.
 * Special filtering is required on library side
 *
 * When there is a guarantee, that no extra filters
 * (i. e. "object is not deleted") were applied,
 * this can be achieved by in-memory filtering (this function)
 *
 * When there is no such guarantee, additional database request is required
 * (see ReaderImpl::removeNonHeadRevisions)
 *
 * Function will maintain ordering of the elements in data
 */
RevisionIds excludeNonHeadRevisions(RevisionIds&& data);
Revisions excludeNonHeadRevisions(Revisions&& data);

} // namespace maps::wiki::revision
