#include <yandex/maps/wiki/revision/revisionid.h>
#include "helpers.h"
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::revision {

using namespace helpers;

std::istream&
operator >> (std::istream& is, RevisionID& rid)
{
    DBID id = 0;
    char ch = 0;

    if (!(is >> id) || !(is >> ch)) {
        is.setstate(std::ios_base::failbit);
        return is;
    }

    if (ch != ':') {
        is.setstate(std::ios_base::failbit);
        return is;
    }

    DBID commitId = 0;
    if (!(is >> commitId)) {
        is.setstate(std::ios_base::failbit);
        return is;
    }

    rid = commitId
        ? RevisionID(id, commitId)
        : RevisionID::createNewID(id);

    return is;
}

std::ostream&
operator << (std::ostream& os, const RevisionID& rid)
{
    os << rid.objectId() << ":" << rid.commitId();
    return os;
}


RevisionID::RevisionID(DBID objectId, DBID commitId)
    : objectId_(objectId)
    , commitId_(commitId)
{
    checkObjectId(objectId);
    checkCommitId(commitId);
}

RevisionID::RevisionID(DBID objectId)
    : objectId_(objectId)
     
{
    REQUIRE(objectId, "invalid new object id");
}

} // namespace maps::wiki::revision
