#pragma once

#include "reader_impl.h"
#include <yandex/maps/wiki/revision/snapshot.h>

#include <maps/libs/common/include/pimpl_utils.h>

#include <memory>

namespace maps::wiki::revision {

class RevisionsGatewayImpl
{
public:
    RevisionsGatewayImpl(pqxx::transaction_base& work, BranchType type, DBID branchId);

    pqxx::transaction_base& work() const { return reader_->work(); }
    BranchType branchType() const { return reader_->branchType(); }
    DBID branchId() const { return reader_->branchId(); }

    const std::shared_ptr<ReaderImpl>& readerImpl() const { return reader_; }

    void checkReadOnlyBranch() const;

    void truncateAll() const;
    void createDefaultBranches() const;

    DBID headCommitId() const;
    SnapshotId maxSnapshotId() const;
private:
    std::shared_ptr<ReaderImpl> reader_;
};

} // namespace maps::wiki::revision
