#pragma once

#include "reader_impl.h"
#include <yandex/maps/wiki/revision/snapshot_id.h>

#include <memory>
#include <utility>

namespace maps::wiki::revision {

class SnapshotImpl
{
public:
    SnapshotImpl(
        std::shared_ptr<ReaderImpl> reader,
        SnapshotId id
    )
        : reader(std::move(reader))
        , id(std::move(id))
    {
    }

    const std::shared_ptr<ReaderImpl> reader;
    const SnapshotId id;
};

class HistoricalSnapshotImpl
{
public:
    HistoricalSnapshotImpl(
            std::shared_ptr<ReaderImpl> reader,
            DBID minCommitId,
            DBID maxCommitId)
        : reader(std::move(reader))
        , minCommitId(minCommitId)
        , maxCommitId(maxCommitId)
    {}

    const std::shared_ptr<ReaderImpl> reader;
    const DBID minCommitId;
    const DBID maxCommitId;
};

} // namespace maps::wiki::revision
