#include "sql_strings.h"

#include <sstream>
#include <string>

namespace maps::wiki::revision::sql {

std::string makeColumnExpr(
    const std::string& column,
    const OptionalString& tableAlias
)
{
    std::ostringstream query;
    if (tableAlias) {
        query << *tableAlias << ".";
    }
    query << column;
    return query.str();
}


std::string makeColumnExpr(
    const std::string& column,
    const OptionalString& tableAlias,
    const OptionalString& transformFunc,
    const OptionalString& columnAlias
)
{
    std::ostringstream query;
    if (transformFunc) {
        query << *transformFunc << "(" <<
            makeColumnExpr(column, tableAlias) <<
        ") ";
    } else {
        query << makeColumnExpr(column, tableAlias);
    }

    if (columnAlias) {
        query << " AS " << *columnAlias;
    }
    return query.str();
}

} // namespace maps::wiki::revision::sql
