#pragma once

#include "common.h"

#include <string>

namespace maps::wiki::revision::sql {

namespace schema {

const std::string REVISION = "revision";
const std::string INFO = "information_schema";

} // namespace schema

namespace table {

const std::string OBJECT_REVISION = schema::REVISION + ".object_revision";
const std::string OBJECT_REVISION_RELATION = schema::REVISION + ".object_revision_relation";
const std::string OBJECT_REVISION_WITH_GEOMETRY = schema::REVISION + ".object_revision_with_geometry";
const std::string OBJECT_REVISION_WITHOUT_GEOMETRY = schema::REVISION + ".object_revision_without_geometry";
const std::string ATTRIBUTES = schema::REVISION + ".attributes";
const std::string ATTRIBUTES_RELATIONS = schema::REVISION + ".attributes_relations";
const std::string COMMIT = schema::REVISION + ".commit";
const std::string GEOMETRY = schema::REVISION + ".geometry";
const std::string DESCRIPTION = schema::REVISION + ".description";
const std::string BRANCH = schema::REVISION + ".branch";

const std::string SEQUENCES = schema::INFO + ".sequences";

} //namespace table

namespace alias {

const std::string OBJECT_REVISION = "o";
const std::string COMMIT = "c";
const std::string ATTRIBUTES = "a";
const std::string GEOMETRY = "g";
const std::string DESCRIPTION = "d";

} //namespace alias

namespace seq {

const std::string OBJECT_ID = schema::REVISION + ".object_id_seq";
const std::string BRANCH_ID = schema::REVISION + ".branch_id_seq";
const std::string APPROVE_ORDER = schema::REVISION + ".approve_order_seq";

} // namespace seq

namespace col {

const std::string ID = "id";

const std::string OBJECT_ID = "object_id";
const std::string COMMIT_ID = "commit_id";
const std::string PREV_COMMIT_ID = "prev_commit_id";
const std::string NEXT_COMMIT_ID = "next_commit_id";
const std::string IS_DELETED = "deleted";
const std::string APPROVE_ORDER = "approve_order";
const std::string NEXT_APPROVE_ORDER = "next_approve_order";
const std::string ATTRIBUTES_ID = "attributes_id";
const std::string GEOMETRY_ID = "geometry_id";
const std::string DESCRIPTION_ID = "description_id";
const std::string MASTER_OBJECT_ID = "master_object_id";
const std::string SLAVE_OBJECT_ID = "slave_object_id";

const std::string ATTRIBUTES = "attributes";
const std::string GEOMETRY = "geometry";
const std::string DESCRIPTION = "description";
const std::string CONTENTS = "contents";

const std::string STATE = "state";
const std::string IS_TRUNK = "trunk";
const std::string STABLE_BRANCH_ID = "stable_branch_id";

const std::string TYPE = "type";
const std::string CREATED_AT = "created";
const std::string CREATED_BY = "created_by";
const std::string FINISHED_AT = "finished";
const std::string FINISHED_BY = "finished_by";

const std::string LAST_VALUE = "lastval";
const std::string NEXT_VALUE = "nextval";

const std::string ATTR_REVERTED_COMMIT_IDS = "_reverted_commit_ids";
const std::string ATTR_REVERTED_DIRECTLY_COMMIT_IDS = "_reverted_directly_commit_ids";
const std::string ATTR_REVERTING_COMMIT_IDS = "_reverting_commit_ids";
const std::string ATTR_REVERTING_DIRECTLY_COMMIT_ID = "_reverting_directly_commit_id";


} // namespace col

namespace val {

const std::string COMMIT_STATE_DRAFT = "draft";
const std::string COMMIT_STATE_APPROVED = "approved";

const std::string BRANCH_STATE_PROGRESS = "progress";
const std::string BRANCH_STATE_NORMAL = "normal";
const std::string BRANCH_STATE_UNAVAILABLE = "unavailable";

const std::string BRANCH_TYPE_TRUNK = "trunk";
const std::string BRANCH_TYPE_APPROVED = "approved";
const std::string BRANCH_TYPE_STABLE = "stable";
const std::string BRANCH_TYPE_ARCHIVE = "archive";
const std::string BRANCH_TYPE_DELETED = "deleted";

const std::string UNDEFINED = "null";
const std::string FALSE = "false";
const std::string TRUE = "true";

const std::string GEOMETRY_SRID = "3395";

} // namespace val

namespace func {

const std::string HSTORE_TO_ARRAY = "hstore_to_array";
const std::string GEOM_TO_BINARY = "ST_AsBinary";
const std::string NEXT_VALUE = "nextval";
const std::string CURR_VALUE = "currval";
const std::string LAST_VALUE = "lastval";

} // namespace func

namespace op {

const std::string LOGICAL_OR = "OR";
const std::string LOGICAL_AND = "AND";

} // namespace op

//returns single-part of SELECT list
std::string makeColumnExpr(
    const std::string& column,
    const OptionalString& tableAlias
);

std::string makeColumnExpr(
    const std::string& column,
    const OptionalString& tableAlias,
    const OptionalString& transformFunc,
    const OptionalString& columnAlias
);

} // namespace maps::wiki::revision::sql

