#include "revision_creator.h"

#include <array>


namespace maps::wiki::revision::tests {

RevisionID RevisionCreator::create()
{
    const auto prevRevId = prevRevId_ ? *prevRevId_ : gateway_.acquireObjectId();

    const auto commit = gateway_.createCommit(
        {RevisionsGateway::NewRevisionData(prevRevId, objectData_)},
        createdBy_,
        commitAttrs_
    );

    return RevisionID(prevRevId.objectId(), commit.id());
}


RevisionID
makeRelation(
    pqxx::transaction_base& txn,
    const std::string& roleId,
    DBID masterObjectId,
    DBID slaveObjectId)
{
    return RevisionCreator(txn)
        .objectAttrs({{"rel:role", roleId}})
        .relationData({masterObjectId, slaveObjectId})();
}

} // namespace maps::wiki::revision::tests
