#pragma once

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/geom.h>
#include <maps/wikimap/mapspro/libs/revision/include/yandex/maps/wiki/revision/revisionsgateway.h>

#include <pqxx/pqxx>

#include <optional>


namespace maps::wiki::revision::tests {

class RevisionCreator final {
public:
    RevisionCreator(pqxx::transaction_base& txn)
        : gateway_(txn)
    {}

    RevisionID create();
    RevisionID operator()() { return create(); }

    RevisionCreator& createdBy(UserID value) { createdBy_ = value; return *this; }
    RevisionCreator& prevRevId(RevisionID value) { prevRevId_ = value; return *this; }
    RevisionCreator& commitAttrs(Attributes value) { commitAttrs_ = std::move(value); return *this; }

    RevisionCreator& objectAttrs(Attributes value) { objectData_.attributes = std::move(value); return *this; }
    RevisionCreator& geometry(const std::string& wkt) { objectData_.geometry = common::wkt2wkb(wkt); return *this; }
    RevisionCreator& description(Description value) { objectData_.description = std::move(value); return *this; }
    RevisionCreator& relationData(RelationData value) { objectData_.relationData = std::move(value); return *this; }

private:
    RevisionsGateway gateway_;
    UserID createdBy_ = 1;
    std::optional<RevisionID> prevRevId_;
    ObjectData objectData_;
    Attributes commitAttrs_ = {{"action", "create"}};
};


RevisionID
makeRelation(pqxx::transaction_base& txn, const std::string& roleId, DBID masterObjectId, DBID slaveObjectId);

} // namespace maps::wiki::revision::tests
