#pragma once

#include <maps/wikimap/mapspro/libs/revision_meta/include/common.h>

#include "graph.h"
#include "preapproved_commits_relations.h"

namespace maps::wiki::revision_meta::impl {

Graph<TCommitId>::Components
getAllComponents(const TCommitIds& preApprovedCommits, const Relations& relations);

Graph<TCommitId>::Component
getComponent(const Graph<TCommitId>::Components& components, TCommitId commitId);

TCommitIds
getBlockingCommits(
    TCommitId commitId,
    const TCommitIds& preApprovedCommits,
    const Relations& relations,
    const TCommitIds& commitIdsWithActiveTasks);

TCommitIds
getCommitsReadyForApprove(
    const TCommitIds& preApprovedCommits,
    const Relations& relations,
    const TCommitIds& commitIdsWithActiveTasks);

} // namespace maps::wiki::revision_meta::impl
