#pragma once

#include <maps/wikimap/mapspro/libs/revision_meta/include/common.h>

#include <maps/libs/introspection/include/comparison.h>
#include <maps/libs/introspection/include/hashing.h>

#include <pqxx/pqxx>

#include <unordered_set>

namespace maps::wiki::revision_meta {

struct Relation {
    TCommitId commitId;
    TCommitId relatesTo;

    auto introspect() const {
        return std::tie(this->commitId, this->relatesTo);
    }
};
using maps::introspection::operator==;
using Relations = std::unordered_set<Relation, introspection::Hasher>;

void
addCommitRelations(
    pqxx::transaction_base& txnCore,
    TCommitId commitId,
    TCommitIds::const_iterator relatesToCommitIdsBegin,
    TCommitIds::const_iterator relatesToCommitIdsEnd);

void
deleteCommitRelations(
    pqxx::transaction_base& txnCore,
    const TCommitIds& commitIds);

Relations
getAllRelations(
    pqxx::transaction_base& txnCore);

} // namespace maps::wiki::revision_meta
