#include <maps/wikimap/mapspro/libs/revision_meta/include/utils.h>

#include <maps/wikimap/mapspro/libs/revision_meta/include/approved_queue.h>
#include <maps/wikimap/mapspro/libs/revision_meta/impl/blocking_commits_impl.h>

#include <yandex/maps/wiki/common/batch.h>
#include <yandex/maps/wiki/common/string_utils.h>
#include <yandex/maps/wiki/revision/commit_manager.h>
#include <yandex/maps/wiki/social/gateway.h>
#include <yandex/maps/wiki/threadutils/executor.h>

#include <maps/libs/common/include/profiletimer.h>
#include <maps/libs/log8/include/log8.h>

#include <mutex>

namespace maps::wiki::revision_meta {

void enqueueCommitsForApprovedBranch(
    pqxx::transaction_base& txnCore,
    const TCommitIds& commitIds)
{
    PreApprovedQueue(txnCore).push(commitIds);
}

void enqueueServiceTaskCommitsForApprovedBranch(
    pqxx::transaction_base& txnCore,
    const TCommitIds& commitIds)
{
    PreApprovedQueue(txnCore).pushServiceTaskCommits(commitIds);
}

void moveFromPreApprovedToApprovedQueueIfPossible(
    pqxx::transaction_base& coreWriteTxn,
    const TCommitIds& commitIdsWithActiveTasks)
{
    ProfileTimer pt;

    PreApprovedQueue preApprovedQueue(coreWriteTxn);

    const auto preApprovedQueueSize = preApprovedQueue.size();
    if (preApprovedQueueSize == 0) {
        INFO() << "PreApproved queue is empty.";
        return;
    }

    const auto commitsToApprove = impl::getCommitsReadyForApprove(
        preApprovedQueue.readAllCommitIds(),
        getAllRelations(coreWriteTxn),
        commitIdsWithActiveTasks
    );
    if (!commitsToApprove.empty()) {
        ApprovedQueue(coreWriteTxn, ApprovedQueueMode::ViewAttrs)
            .push(commitsToApprove);
        preApprovedQueue.deleteCommits(commitsToApprove);
    }

    INFO() << "PreApproved queue size " << preApprovedQueueSize
        << "; moved to approved queue " << commitsToApprove.size()
        << "; remains " << preApprovedQueueSize - commitsToApprove.size();
    INFO() << "PreApproved queue processing took " << pt << " seconds";
}

} // namespace maps::wiki::revision_meta
