#pragma once

#include <maps/wikimap/mapspro/libs/revision_meta/include/common.h>

#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <pqxx/pqxx>

#include <chrono>

namespace maps::wiki::revision_meta {

enum class ApprovedQueueMode
{
    PreApprove,
    ViewAttrs,
    Labels,
    Bboxes
};

DECLARE_ENUM_IO(ApprovedQueueMode);

class ApprovedQueue
{
public:
    ApprovedQueue(pqxx::transaction_base& txn, ApprovedQueueMode mode)
        : txn_(txn)
        , mode_(mode)
    {}

    virtual ~ApprovedQueue() = default;

    pqxx::transaction_base& txn() const { return txn_; }
    ApprovedQueueMode mode() const { return mode_; }

    size_t size();

    TCommitIds readCommitIds(const TCommitIds& commitIds);
    TCommitIds readAllCommitIds();

    void deleteCommits(const TCommitIds& commitIds);

    void push(const TCommitIds& commitIds);

protected:
    pqxx::transaction_base& txn_;
    ApprovedQueueMode mode_;
};

class PreApprovedQueue: public ApprovedQueue {
public:
    explicit PreApprovedQueue(pqxx::transaction_base& txn);

    void push(const TCommitIds& commitIds);
    void pushServiceTaskCommits(const TCommitIds& commitIds);
    void deleteCommits(const TCommitIds& commitIds);

    std::chrono::seconds oldestCommitAge();
};

} // namespace maps::wiki::revision_meta
