#pragma once

#include <maps/wikimap/mapspro/libs/revision_meta/include/common.h>
#include <maps/libs/chrono/include/days.h>
#include <yandex/maps/wiki/revision/branch.h>

#include <pqxx/pqxx>

namespace maps {
namespace wiki {
namespace revision_meta {

class CommitRegions
{
public:
    explicit CommitRegions(pqxx::transaction_base& txn)
        : txn_(txn)
    {}

    void push(
        TCommitId commitId,
        const TOIds& regionIds) const;

    TCommitToRegions getCommitRegions(const TCommitIds& commitIds) const;

    void toStable(
        const revision::Branch& branch,
        const TCommitIds& commitIds) const;

    TCommitIds loadNotPublished(
        const TCommitIds& commitIds) const;

    TCommitIds getNotPublished(
        TOId regionId,
        const TBranchIds& branchIds) const;

    void publish(const TCommitIds& commitIds) const;

    /**
     * Remove published commits older than the given days number.
     * @return The number of affected rows
     */
    size_t removeOldPublishedCommits(chrono::Days days = chrono::Days(90)) const;

private:
    pqxx::transaction_base& txn_;
};

} // namespace revision_meta
} // namespace wiki
} // namespace maps
