#pragma once

#include <yandex/maps/wiki/revisionapi/export_params.h>

#include <yandex/maps/wiki/revision/branch.h>
#include <yandex/maps/wiki/revision/filters.h>

namespace maps::wiki::revisionapi {

class ExportParams::Impl
{
public:
    Impl(
        revision::Branch branch,
        revision::DBID commitId,
        RelationsExportFlags flags);

    revision::Branch branch;
    revision::DBID commitId;
    RelationsExportFlags flags;
    size_t writeBatchSize;
    Strings invertDirectionRoles;
    EmptyJsonPolicy emptyJsonPolicy;

    FilterPtr filter;
    std::set<std::string> categories;
    std::set<std::string> categoriesForFilter;
    std::set<std::string> allowedRelativesCategories;

    void setCategoriesForFilter(const Strings& categories);
};

} // namespace maps::wiki::revisionapi
