#pragma once

#include <yandex/maps/wiki/revisionapi/revisionapi.h>
#include <yandex/maps/wiki/revision/filters.h>

#include <vector>

namespace revision = maps::wiki::revision;
namespace filters = revision::filters;

namespace maps::wiki::revisionapi {

class ExportParams;

class Exporter {
public:
    explicit Exporter(pgpool3::Pool& pool);

    void exportToJsonByFilter(
        const ExportParams& params,
        GetStreamForChunkFunc getStreamForChunkFunc,
        const FilterPtr& filter);

    void exportToJsonByObjectIds(
        const ExportParams& params,
        GetStreamForChunkFunc getStreamForChunkFunc,
        const std::vector<revision::DBID>& objectIds);

private:
    pgpool3::Pool& pool_;
};

} // namespace maps::wiki::revisionapi
