#include "jsonhelper.h"

namespace maps::wiki::revisionapi {

revision::Attributes json2attributes(const json::Value& attrs)
{
    revision::Attributes result;
    for (const auto& attrName: attrs.fields()) {
        result[attrName] = attrs[attrName].as<std::string>();
    }
    return result;
}

void attributes2json(
    json::ObjectBuilder& builder,
    const revision::Attributes& attributes)
{
    for (const auto& pair: attributes) {
        builder[pair.first] = pair.second;
    }
}

} // namespace maps::wiki::revisionapi
