#pragma once

#include <yandex/maps/wiki/revision/common.h>
#include <maps/libs/json/include/value.h>
#include <maps/libs/json/include/builder.h>

#include <string>

namespace json = maps::json;
namespace revision = maps::wiki::revision;

namespace maps::wiki::revisionapi {

const std::string JSON_FIELD_OBJECTS = "objects";
const std::string JSON_FIELD_ATTRIBUTES = "attributes";
const std::string JSON_FIELD_DESCRIPTION = "description";
const std::string JSON_FIELD_GEOMETRY = "geometry";
const std::string JSON_FIELD_RELATIONS = "relations";
const std::string JSON_FIELD_SLAVE = "slave";
const std::string JSON_FIELD_MASTER = "master";
const std::string JSON_FIELD_NEXT_FREE_OBJECT_ID = "next_free_object_id";
const std::string JSON_FIELD_RELATIONS_EXPORT_MODE = "relations_export_mode";
const std::string JSON_FIELD_INVERT_DIRECTIONS_FOR_ROLES = "invert_direction_for_roles";

revision::Attributes json2attributes(const json::Value& attrs);

void attributes2json(
    json::ObjectBuilder& builder,
    const revision::Attributes& attributes);

} // namespace maps::wiki::revisionapi
