#include <yandex/maps/wiki/routing/common.h>

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace routing {

class DirectedElementID::Impl {
public:
    ID id;
    Direction direction;
};

COPYABLE_PIMPL_DEFINITIONS(DirectedElementID)

DirectedElementID::DirectedElementID(ID id, Direction direction)
    : impl_(new Impl{id, direction})
{
    REQUIRE(
        direction != Direction::Both,
        "Only one direction possible"
    );
}

ID DirectedElementID::id() const { return impl_->id; }

Direction DirectedElementID::direction() const { return impl_->direction; }

bool operator==(const DirectedElementID& lhs, const DirectedElementID& rhs)
{
    return lhs.id() == rhs.id() && lhs.direction() == rhs.direction();
}

bool operator!=(const DirectedElementID& lhs, const DirectedElementID& rhs)
{
    return !(lhs == rhs);
}

bool operator<(const DirectedElementID& lhs, const DirectedElementID& rhs)
{
    return (lhs.id() < rhs.id()) || (lhs.id() == rhs.id() && lhs.direction() < rhs.direction());
}

} // namespace routing
} // namespace wiki
} // namespace maps



