#include <yandex/maps/wiki/routing/condition.h>

#include <maps/libs/common/include/exception.h>

#include <utility>

namespace maps {
namespace wiki {
namespace routing {

class Condition::Impl {
public:
    Impl(ID id, common::ConditionType type, ID fromElementId, ID viaJunctionId, Ids&& toElementIds)
        : id(id)
        , type(type)
        , fromElementId(fromElementId)
        , viaJunctionId(viaJunctionId)
        , toElementIds(std::move(toElementIds))
    {}

    ID id;
    common::ConditionType type;
    ID fromElementId;
    ID viaJunctionId;
    Ids toElementIds;
};

COPYABLE_PIMPL_DEFINITIONS(Condition)

Condition::Condition(ID id, common::ConditionType type, ID fromElementId, ID viaJunctionId, Ids toElementIds)
    : impl_(new Impl{id, type, fromElementId, viaJunctionId, std::move(toElementIds)})
{}

ID Condition::id() const { return impl_->id; }

common::ConditionType Condition::type() const { return impl_->type; }

ID Condition::fromElementId() const { return impl_->fromElementId; }

ID Condition::viaJunctionId() const { return impl_->viaJunctionId; }

const Ids& Condition::toElementIds() const { return impl_->toElementIds; }

} // namespace routing
} // namespace wiki
} // namespace maps
