#include <yandex/maps/wiki/routing/element.h>

#include <utility>

namespace maps {
namespace wiki {
namespace routing {

class ElementEnd::Impl {
public:
    ID junctionId;
    int zlev;
};

ElementEnd::ElementEnd(ID junctionId, int zlev): impl_(new Impl{junctionId, zlev}) {}

COPYABLE_PIMPL_DEFINITIONS(ElementEnd)

ID ElementEnd::junctionId() const { return impl_->junctionId; }

int ElementEnd::zlev() const { return impl_->zlev; }

bool operator<(const ElementEnd& lhs, const ElementEnd& rhs)
{
    return (lhs.junctionId() < rhs.junctionId())
        || (lhs.junctionId() == rhs.junctionId() && lhs.zlev() < rhs.zlev());
}

class Element::Impl {
public:
    Impl(
            ID id,
            Direction direction,
            Polyline&& polyline,
            const ElementEnd& start,
            const ElementEnd end)
        : id(id)
        , direction(direction)
        , polyline(std::move(polyline))
        , start(start)
        , end(end)
    {}

    ID id;
    Direction direction;
    Polyline polyline;
    ElementEnd start;
    ElementEnd end;
};

Element::Element(
        ID id,
        Direction direction,
        Polyline polyline,
        const ElementEnd& start,
        const ElementEnd& end)
    : impl_(new Impl{id, direction, std::move(polyline), start, end})
{}

COPYABLE_PIMPL_DEFINITIONS(Element)

ID Element::id() const { return impl_->id; }

Direction Element::direction() const { return impl_->direction; }

const Polyline& Element::geom() const { return impl_->polyline; }

const ElementEnd& Element::start() const { return impl_->start; }

const ElementEnd& Element::end() const { return impl_->end; }

} // namespace routing
} // namespace wiki
} // namespace maps
