#include <yandex/maps/wiki/routing/exception.h>

#include <yandex/maps/wiki/common/string_utils.h>

#include <sstream>
#include <string>
#include <utility>

namespace maps {
namespace wiki {
namespace routing {

namespace {

std::string printImpossibleSnapStopIds(const IdSet& stopIds)
{
    std::ostringstream out;
    out << "Impossible snap stops {" << common::join(stopIds, ",") << "}";
    return out.str();
}

} // namespace

BaseRoutingError::BaseRoutingError(std::string description)
    : LogicError(std::move(description))
{}

BadParam::BadParam(std::string description): BaseRoutingError(std::move(description)) {}

class ImpossibleSnapStopError::Impl {
public:
    Impl(IdSet&& stopIds): stopIds(std::move(stopIds)) {}

    IdSet stopIds;
};

ImpossibleSnapStopError::ImpossibleSnapStopError(IdSet stopIds)
    : BaseRoutingError(printImpossibleSnapStopIds(stopIds))
    , impl_(new Impl{std::move(stopIds)})
{}

ImpossibleSnapStopError::ImpossibleSnapStopError(ImpossibleSnapStopError&& other)
    : BaseRoutingError(std::move(other))
    , impl_(std::move(other.impl_))
{}

ImpossibleSnapStopError::~ImpossibleSnapStopError()  noexcept(true) = default;

const IdSet& ImpossibleSnapStopError::stopIds() const { return impl_->stopIds; }

} // namespace routing
} // namespace wiki
} // namespace maps


