#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>

#include <maps/libs/common/include/pimpl_utils.h>
#include <maps/libs/ymapsdf/include/rd.h>

#include <cstddef>
#include <cstdint>
#include <vector>
#include <set>

namespace maps {
namespace wiki {
namespace routing {

typedef uint64_t ID;
typedef std::set<ID> IdSet;
typedef std::vector<ID> Ids;

typedef geolib3::Point2 Point;
typedef geolib3::Polyline2 Polyline;

typedef ymapsdf::rd::Direction Direction;

class DirectedElementID {

public:
    DirectedElementID(ID id, Direction direction);

    ID id() const;
    Direction direction() const;

    COPYABLE_PIMPL_DECLARATIONS(DirectedElementID)
};

bool operator==(const DirectedElementID& lhs, const DirectedElementID& rhs);
bool operator!=(const DirectedElementID& lhs, const DirectedElementID& rhs);

bool operator<(const DirectedElementID& lhs, const DirectedElementID& rhs);

} // namespace routing
} // namespace wiki
} // namespace maps
