#pragma once

#include <yandex/maps/wiki/common/rd/cond_type.h>
#include <yandex/maps/wiki/routing/common.h>
#include <maps/libs/common/include/pimpl_utils.h>

#include <vector>

namespace maps {
namespace wiki {
namespace routing {

class Condition {

public:
    Condition(ID id, common::ConditionType type, ID fromElementId, ID viaJunctionId, Ids toElementIds);

    ID id() const;
    common::ConditionType type() const;

    ID fromElementId() const;
    ID viaJunctionId() const;
    const Ids& toElementIds() const;

    COPYABLE_PIMPL_DECLARATIONS(Condition)
};

typedef std::vector<Condition> Conditions;

} // namespace routing
} // namespace wiki
} // namespace maps
