#pragma once

#include <yandex/maps/wiki/routing/common.h>
#include <maps/libs/common/include/pimpl_utils.h>

#include <vector>

namespace maps {
namespace wiki {
namespace routing {

class ElementEnd {

public:
    ElementEnd(ID junctionId, int zlev);

    ID junctionId() const;
    int zlev() const;

    COPYABLE_PIMPL_DECLARATIONS(ElementEnd)
 };

 bool operator<(const ElementEnd& lhs, const ElementEnd& rhs);


class Element {

public:
    Element(
        ID id,
        Direction direction,
        Polyline polyline,
        const ElementEnd& start,
        const ElementEnd& end);

    ID id() const;

    Direction direction() const;
    const Polyline& geom() const;

    const ElementEnd& start() const;
    const ElementEnd& end() const;

    COPYABLE_PIMPL_DECLARATIONS(Element)
};

typedef std::vector<Element> Elements;

} // namespace routing
} // namespace wiki
} // namespace maps
