#pragma once

#include <yandex/maps/wiki/routing/common.h>

#include <maps/libs/common/include/exception.h>

#include <memory>
#include <string>

namespace maps {
namespace wiki {
namespace routing {


class
BaseRoutingError: public LogicError {

public:
    explicit BaseRoutingError(std::string description);
};

class BadParam: public BaseRoutingError {

public:
    BadParam(std::string description);
};

class
ImpossibleSnapStopError: public BaseRoutingError {

    class Impl;

public:
    ImpossibleSnapStopError(IdSet stopIds);
    ImpossibleSnapStopError(ImpossibleSnapStopError&& other);

    ~ImpossibleSnapStopError() noexcept(true);

    const IdSet& stopIds() const;

private:
    std::unique_ptr<Impl> impl_;
};

} // namespace routing
} // namespace wiki
} // namespace maps


