#pragma once

#include <yandex/maps/wiki/routing/common.h>
#include <yandex/maps/wiki/routing/condition.h>
#include <yandex/maps/wiki/routing/element.h>
#include <yandex/maps/wiki/routing/stop.h>

#include <maps/libs/common/include/pimpl_utils.h>

#include <boost/optional.hpp>

namespace maps {
namespace wiki {
namespace routing {

class StopSnap {

public:
    ID stopId() const;
    double locationOnElement() const;
    const Point& point() const;

    COPYABLE_PIMPL_DECLARATIONS(StopSnap);
};

typedef boost::optional<StopSnap> OptionalStopSnap;


class TracePoint {

public:
    const DirectedElementID& directedElementId() const;
    const OptionalStopSnap& stopSnap() const;

    COPYABLE_PIMPL_DECLARATIONS(TracePoint);
};

typedef std::vector<TracePoint> Trace;


class NoPathError {

public:
    ID fromStopId() const;
    ID toStopId() const;

    COPYABLE_PIMPL_DECLARATIONS(NoPathError);
};

typedef std::vector<NoPathError> NoPathErrors;


class AmbiguousPathError {

public:
    ID fromStopId() const;
    ID toStopId() const;
    ID elementId() const;

    COPYABLE_PIMPL_DECLARATIONS(AmbiguousPathError);
};

typedef std::vector<AmbiguousPathError> AmbiguousPathErrors;


class RestoreResult {

public:
    const Trace& trace() const;

    const IdSet& unusedElementIds() const;
    const AmbiguousPathErrors& forwardAmbiguousPathErrors() const;
    const AmbiguousPathErrors& backwardAmbiguousPathErrors() const;
    const NoPathErrors& noPathErrors() const;

    bool isOk() const;

    MOVABLE_PIMPL_DECLARATIONS(RestoreResult)
};

// Geometry must be in mercator format

RestoreResult restore(
        const Elements& elements,           // list of distinct elements that is used in route
        const Stops& stops,                 // sequence of stops that are visited during route
        double stopSnapToleranceMeters);    // max distance to snap to route element

RestoreResult restore(
        const Elements& elements,           // list of distinct elements that is used in route
        const Stops& stops,                 // sequence of stops that are visited during route
        const Conditions& conditions,       // list of conditions that are meaningful for routing
        double stopSnapToleranceMeters);    // max distance to snap to route element

} // namespace routing
} // namespace wiki
} // namespace maps
