#pragma once

#include <yandex/maps/wiki/routing/route.h>

namespace maps {
namespace wiki {
namespace routing {

class StopSnap::Impl {
public:
    Impl(ID stopId, double locationOnElement, const Point& point)
        : stopId(stopId)
        , locationOnElement(locationOnElement)
        , point(point)
    {}

    ID stopId;
    double locationOnElement;
    Point point;
};

class TracePoint::Impl {
public:
    Impl(const DirectedElementID& directedElementId)
        : directedElementId(directedElementId)
        , stopSnap(boost::none)
    {}

    Impl(const DirectedElementID& directedElementId, const StopSnap& stopSnap)
        : directedElementId(directedElementId)
        , stopSnap(stopSnap)
    {}

    DirectedElementID directedElementId;
    OptionalStopSnap stopSnap;
};

class NoPathError::Impl {
public:
    Impl(ID fromStopId, ID toStopId)
        : fromStopId(fromStopId)
        , toStopId(toStopId)
    {}

    ID fromStopId;
    ID toStopId;
};

class AmbiguousPathError::Impl {
public:
    Impl(ID fromStopId, ID toStopId, ID elementId)
        : fromStopId(fromStopId)
        , toStopId(toStopId)
        , elementId(elementId)
    {}

    ID fromStopId;
    ID toStopId;
    ID elementId;
};

class RestoreResult::Impl {
public:
    Impl(
            Trace trace,
            IdSet unusedElementIds,
            AmbiguousPathErrors forwardAmbiguousPathErrors,
            AmbiguousPathErrors backwardAmbiguousPathErrors,
            NoPathErrors noPathErrors)
        : trace(std::move(trace))
        , unusedElementIds(std::move(unusedElementIds))
        , forwardAmbiguousPathErrors(std::move(forwardAmbiguousPathErrors))
        , backwardAmbiguousPathErrors(std::move(backwardAmbiguousPathErrors))
        , noPathErrors(std::move(noPathErrors))
    {}

    Trace trace;
    IdSet unusedElementIds;
    AmbiguousPathErrors forwardAmbiguousPathErrors;
    AmbiguousPathErrors backwardAmbiguousPathErrors;
    NoPathErrors noPathErrors;
};

} // namespace routing
} // namespace wiki
} // namespace maps
