#include <yandex/maps/wiki/routing/stop.h>

#include <utility>
#include <vector>

namespace maps {
namespace wiki {
namespace routing {

class Stop::Impl {
public:
    Impl(ID id, const Point& point): id(id), point(point) {}

    ID id;
    Point point;
};

Stop::Stop(ID id, const Point& point): impl_(new Impl{id, point}) {}

COPYABLE_PIMPL_DEFINITIONS(Stop)

ID Stop::id() const { return impl_->id; }

const Point& Stop::geom() const { return impl_->point; }

} // namespace routing
} // namespace wiki
} // namespace maps
