#pragma once

#include <maps/wikimap/mapspro/libs/rubrics/include/common.h>
#include <maps/libs/introspection/include/comparison.h>

#include <map>
#include <set>
#include <string>

namespace maps {
namespace wiki {
namespace rubrics {

struct RubricMappingRecord
{
    RubricId rubricId;
    FtTypeId ftTypeId;
    std::string comment;
};

inline auto introspect(const RubricMappingRecord& record)
    -> decltype(std::tie(record.rubricId, record.ftTypeId))
{
    return std::tie(record.rubricId, record.ftTypeId);
}

using introspection::operator==;
using introspection::operator<;

typedef std::map<FtTypeId, std::set<RubricMappingRecord>> RubricMapping;

RubricMapping readBackaMapping(const std::string& fileName);

RubricMapping loadExportPoiMapping(const std::string& content);

RubricMapping readExportPoiMapping(const std::string& fileName);
void writeExportMapping(const RubricMapping& mapping, const std::string& fileName);

} // namespace rubrics
} // namespace wiki
} // namespace maps
